---
title: "Readme GermanSL"
author: "Florian Jansen"
date: "29 09 2025"
output: 
  html_document:
    toc: true
---

Dieser Ordner enthält die Referenzliste der Pflanzen Deutschlands in diversen Formaten, sowie Zusatzdokumente.

<TABLE CELLSPACING="0" COLS="2" BORDER="0">
<TR>
	<TD >Dateiname</TD>
	<TD >Inhalt</TD>
</TR>
<TR>
	<TD STYLE="border-top: 1px solid #000000" >README.html</TD>
	<TD STYLE="border-top: 1px solid #000000" >diese Datei</TD>
</TR>
<TR>
	<TD STYLE="border-top: 1px solid #000000" >ChangeLog.html</TD>
	<TD STYLE="border-top: 1px solid #000000" >Änderungen gegenüber Vorgängerversionen der GermanSL</TD>
</TR>
<TR>
	<TD STYLE="border-top: 1px solid #000000" >germansl.sqlite</TD>
	<TD STYLE="border-top: 1px solid #000000" >GermanSL im SQLite Format (vollwertiges, transportables, plattformunabhängiges Datenbankformat in einer Datei</TD>
</TR>
<TR>
	<TD STYLE="border-top: 1px solid #000000" >species.dbf</TD>
	<TD STYLE="border-top: 1px solid #000000" >GermanSL im Format für das Vegetationsdatenbankprogramm Turboveg 2</TD>
</TR>
<TR>
	<TD STYLE="border-top: 1px solid #000000" >noMatch.gslxx.ods</TD>
	<TD STYLE="border-top: 1px solid #000000" >Datei mit den zu ändernden Taxa gegenüber der letzten Version</TD>
</TR>



Changelog
---------------

**Changelog 1.5.6</strong> (Sept 2025)**
* Ergänzung von 223 Taxa, die in der florenliste-deutschland und/oder der europlusmed als introduced/naturalised bzw. mit Etablierungstendenz genannt sind.

**Changelog 1.5.5</strong> (Jan 2025)**
* Ergänzung von 136 fehlenden, in der https://florenliste-deutschland.de/ als etabliert verzeichneten Taxa.
* Ergänzung Etablierungsstatus nach BfN 519, florenliste-deutschland.de und europlusmed (casual, cultivated,  introduced, native, naturalised, 
E=etablierter Neophyt, F=Angabe falsch, I=indigen, T=Etablierungstendenz, U=unbeständig)

**Changelog 1.5.2</strong> (Apr 2023)**

* Ergänzung von Verdachtsarten aus der Unionsliste *Nehring, S. & Skowronek, S. (2020) Die invasiven gebietsfremden Arten der ersten Unionsliste der EU-Verordnung Nr. 1143/2014 Zweite Fortschreibung 2019. BfN-Skripten 574. Bundesamt für Naturschutz. 191 S. - https://www.bfn.de/sites/default/files/BfN/service/Dokumente/skripten/skript574.pdf* und der Warnliste *RABITSCH, W. et al. (2013): Erstellung einer Warnliste in Deutschland noch nicht vorkommender Tiere und Pflanzen. BfN-Skripten 331. Bundesamt für Naturschutz, Umweltbundesamt. 154 S. - http://www.bfn.de/fileadmin/MDB/documents/service/skript331.pdf*.
* Korrektur von Fehlern in der taxonomischen Hierarchie
* Synonymisierung von Senecio incanus s. l. zu Senecio carniolicus (Jacobaea carniolica)
* Löschen von ca. 40 synonymen "agg." Angaben aus der BfN 519 Liste, die in der Buttler et al. Liste zur Darstellung der Konzeptbeziehungen dienen, in der GermanSL aber lediglich Verwirrung stiften würden, denn "agg." Synonyme machen in der GermanSL bestenfalls als Namenssynonyme anderer Aggregate Sinn, sollten aber ganz vermieden werden.
* Eltern-Kind-Beziehungen von "Centaurea nigra s. l.", "Salix cinerea s. l.", "Saxifraga rosacea s. l.", "Ranunculus polyanthemos s. l.", "Pulsatilla alpina s. l.", "Stipa pulcherrima s. l." korrigiert
* für 72 Taxa unnötige und verwirrende s.l. Bezeichnungen aus der BfN 519 Liste gelöscht

* Erweiterung für in den floristischen Daten von Sachsen vorkommende Taxa
* weitere Deutsche Namen ergänzt 
* Rote Liste Verknüpfung mit https://www.rote-liste-zentrum.de/de/Download-Pflanzen-1871.html


**Changelog 1.5.1</strong>(Sept 2020)**

* Erweiterung für in vegetweb.de, Flora-MV.de und GVRD vorkommende Taxa
* Verbesserungen an der Ersetzungsliste

**Changelog 1.5</strong> (April 2020)**

* Umstellung der gültigen Namen der Gefäßpflanzen auf die zweite Standardliste des Bundesamtes für Naturschutz:</br>
    **Buttler,  May, Metzing (2018) Liste der Gefäßpflanzen Deutschlands, BfN-Skripten 519**.
* Um die Liste zu entschlacken wurden in diesem Zuge viele Namen, de nicht in der Standardliste stehen, in den zugänglichen Datenbanken nie verndet wurden, und/oder missverständlich waren, weggelassen (es handelt sich ganz überwiegend um Namen, die  bereits in der alten Liste als Synonyme gelistet waren).</br>
    	Bitte kontrollieren sie ihre Datensammlung nach den nun fehlenden TaxonUsageID's, bevor sie ihre Datenbank umstellen.
* Um die weitestgehende Übereinstimmung der Taxon ID's mit den seit den 80er Jahren vom BfN vergebenen 5stelligen Nummern weiter aufrecht zu erhalten, wurden des Weiteren knapp tausend Taxa umnummeriert. Das heißt das gleiche Konzept hat jetzt einen neue Nummer. Hierbei war es in keinem Fall notwendig ID's zu verwenden, die in früheren Versionen in einem anderen Sinne verwendet wurden. 
    Das heißt, wenn sie eine alte datenbank mit der neuen Liste verwenden, fehlen ihnen ggf. Namen für bestimmte Nummern,
    aber sie bekommen niemals einen falsches Taxon für eine alte Nummer.
* Eine Liste der notwendigen Überprüfungen und Änderungen von Taxon ID's ist angefügt und detailliert erläutert.


**Changelog 1.4.5</strong> (28.09.2019)**

* Umstellung der Valid Taxa auf die Rote Liste Moose (Caspari, S., Dürhammer, O., Sauer, M., Schmidt, C. (2018). Rote Liste und Gesamtartenliste der Moose (Anthocerotophyta und Bryophyta) Deutschlands. In Rote Liste gefährdeter Tiere, Pflanzen und Pilze Deutschlands Band 7 Pflanzen (S. 361–492). Landwirtschaftsverlag.

* <strong>Umstellung der Höheren Taxonomie der Gefäßpflanzen vom Cronquist (1981) System auf <a href="http://www.mobot.org/MOBOT/research/APweb/">APG IV</a> (2016)</strong>


**Changelog 1.4.1</strong> (11.05.2018)**

* 134 neue europäische Taxa zur Integration der Tüxenarchiv-Daten, belegt aus Euro+Med (http://www.emplantbase.org/home.html, accessed 11.05.2018)

**Changelog 1.4.0</strong> (24.01.2017)**

* 137 Korrekturen geändert (Kartierungstaxa angenommen)
* 134 neue Taxa aus DFlora
* 580 neue Flechtennamen aus Wirth et al. 2013/15
* 49 neue Taxa aus der Roten Liste Moose (2017)
* Umstellung der Taxonomie auf die Rote Liste Moose (2017) !
* gelöschte Arten: 93984 Diervillea = Typo zur schon vorhandenen 65942 Diervilla, im Rahmen der Umstellung auf die RL Moose wurden alle ZUS Arten (provisorische Untergliederungen, erkenntlich am * im Namen) aufgelöst. Sollten diese ID's verwendet worden sein, müssen die Daten beim Wechsel von der GermanSL 1.3 auf die 1.4 entsprechend neu zugeordnet werden.


**Changelog 1.3.4</strong> (21.09.2016)**

* neue Arten: Dianthus giganteus, Gleditsia triacanthos, Hydrocotyle ranunculoides, Impatiens balfourii, 
Impatiens edgeworthii, Lonicera henryi, Ludwigia grandiflora, Ludwigia x kentiana, Miscanthus sacchariflorus, Miscanthus sinensis, Myriophyllum aquaticum, Rhododendron ponticum, Viburnum rhytidophyllum
* Status von Kalmia procumbens (Namenssynonym von Leuseleuria procumbens) korrigiert
* Viola curtisii und ihr Wissk.-Synonym Viola tricolor subsp. curtisii fehlten aufgrund fehlerhafter LIST Kategorie</li>


**Changelog 1.3.3</strong> (14.03.2016)**

* neue Arten Flora-MV, Korrektur Schreibfehler

**Changelog 1.3.2</strong> (22.02.2016)**

* neue Arten Jan Eckstein, Anpassung am Code zur Erstellung
    
**Changelog 1.3.1</strong> (17.11.2015)**

* Bugfixes in den Lettercodes

<strong>Changelog 1.3</strong> (08.09.2015)<br/>

* Bereinigung der taxonomischen Hierarchie</li>
* Löschen lichenicoler Pilze</li>
* sowohl species.dbf als auch tax.dbf benutzen nun die Codepage CP437 zwecks Kompatibilität mit Turboveg</li>

    
<strong>Changelog 1.2.3</strong> (01.07.2013)<br/>

* verbesserter Umgang mit Umlauten, die species.dbf benutzt aufgrund der dBase und Turboveg Konventionen CP437/CP850 als encoding, die tax.dbf hingegen UTF8
* die Gattung Habrodon hatte die gleiche TaxonUsageID wie Epilobium x semiobscurum (99024)
* Korrekturen von Schreibfehlern Odontites litroralis * litoralis, Pulsatilla vernals x vulgaris, Rubus corylifolius agg. et fruticosus ag., Tritomaria quinquedentata subsp. quinquedentata var. quinquedentata
* Bereinigtes Feld VALID_NAME (Taxon Concept Name) in der tax.dbf. Generell sollte aber im Zweifelsfall immer der Species Name (ABBREVIAT) der in der Valid_Nr genannten Species_Nr verwendet werden.
* Löschung von Buglossoides arvensis subsp. sibthorpianum (TaxNr 90453), da falsche Schreibweise und Buglossoides arvensis subsp. sibthorpiana (20947) schon vorhanden
* neue Taxa "Epilobium x semiobscurum, Juncus x brueggeri, Oenothera cambrica, Rhinanthus glaber, Spergularia maritima subsp. maritima


<strong>Changelog 1.2.2</strong> (18.01.2012) <br/>
Gegenüber der Version 1.2.2 wurden einige Fehler in der Aggregierungsinformation, sowie der Angabe der taxonomischen Rangstufe korrigiert. In der tax.dbf gibt es nun eine Angabe der Familienzugehörigkeits aller gültigen Taxa. Die Angabe "Incertae sedis" steht für eine ungewisse Zuordnung (vor allem bei den Algen). </p>

<strong>Changelog 1.2.1</strong>  (25.09.2011) <br/>
Gegenüber der Version 1.2 wurden einige Fehler in der taxonomischen Hierarchie höherer Syntaxa behoben. </p>





<h2>Inhalt</h2>
Dieser Ordner enthält die Referenzliste der Pflanzen Deustchlands in diversen Formaten und Zusatzdokumenten.

<TABLE CELLSPACING="0" COLS="2" BORDER="0">
	<TR>
		<TD >Dateiname</TD>
		<TD >Inhalt</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" >README.html</TD>
		<TD STYLE="border-top: 1px solid #000000" >diese Datei</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" >ChangeLog.html</TD>
		<TD STYLE="border-top: 1px solid #000000" >Änderungen gegenüber Vorgängerversionen der GermanSL</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" >germansl.sqlite</TD>
		<TD STYLE="border-top: 1px solid #000000" >GermanSL im SQLite Format (vollwertiges, transportables, plattformunabhängiges Datenbankformat</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" >species.dbf</TD>
		<TD STYLE="border-top: 1px solid #000000" >GermanSL im passenden Format für das Vegetationsdatenbank Turboveg 2</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" >noMatch.gsl1.5.ods</TD>
		<TD STYLE="border-top: 1px solid #000000" >Datei mit den zu ändernden Taxa gegenüber der Version 1.4</TD>
	</TR>


Generelle Hinweise
-------------------------------

Für das Verständnis des taxonomischen Inhalts eines Taxons ist nicht der Namensautor wichtig, sondern das Secundum, 
das heißt auf welche Flora oder Chekcliste sich die Angabe bezieht, siehe dazu die Diskussion zu Taxon Concepts (e.g. Berendsohn 1995).
Der wissenschaftliche Name bezieht sich erst einmal nur auf ein einziges Herbarexemplar, das Typusexemplar. Erst die Merkmalsbeschreibung, der Zusammenhang 
(wer ist sonst noch für dieses gebiet beschrieben), oder der explizite Bezug auf andere Konzepte (enthält, enthält nicht etc.) ermöglicht die Nutzung 
für biologische Beobachtungsdatensammlungen.


Erläuterung der Felder
------------------------------

<h3>Taxon Identifikatoren</h3>

Aus pragmtischen Gründen und weil Taxa im Zweifelsfalle nur mit vollem wissenschaftlichen Namen inklusive Namensautor plus Secundum (Quelle des Taxonkonzeptes) eindeutig beschrieben sind, 
besitzen alle elektronischen Referenzlisten (alpha)numerische Identifikatoren. Auch wenn global eindeutige Identikatoren (z.B. UUID's) eigentlich zu bevorzugen sind, verwenden viele Listen numerische Ganzzahlen als Identifikatoren.
Die GermanSL übernimmt die in den Referenzlisten des BfN eingeführten ID's für Gefäßpflanzen, Moose, Flechten und Höhere Taxa. So hat Abies alba die Identifikationsnummer 1, Urtica dioica die 6145.

Gleiche Nummern bedeuten immer gleichen taxonomischen Inhalt (ggf. aber neue Namensschreibweisen) in allen bisherigen Versionen (1.x) der GermanSL.

Nummernbereiche
<ul>
	<li>1:</li>
	<li>40000er = Flechten</li>
	<li>60000er = höhere Taxa</li>
	<li>80000er = Moose</li>
	<li>90000er = frei vergebene ID's</li>
</ul>

<h3>Erläuterung der Felder für die Turboveg Versionen der GermanSL (species.dbf)</h3>

<TABLE CELLSPACING="0" COLS="2" BORDER="0">
	<TR>
		<TD >Feldname</TD>
		<TD >Definition</TD>
	</TR>
	<TR>
		<TD STYLE="border-top: 1px solid #000000" HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">SPECIES_NR</FONT></TD>
		<TD STYLE="border-top: 1px solid #000000" ALIGN="LEFT"><FONT FACE="Times New Roman">5-stellige, eindeutige Taxonym-Nummer (1–86.999: aus den elektronischen Listen des BfN; 87.000–99.000: Ergänzungsliste; ab 99.001: Platz für benutzerdefinierte Taxa </FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">LETTERCODE</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">7-stelliger, eindeutiger Taxonym-Code für angenommenen Namen (4 Buchstaben für die Gattung, 3 für das Epithet)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">SHORTNAME</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">auf 22 Zeichen abgekürzter Artname</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">ABBREVIAT</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">56-stelliger Sippenname (eindeutig)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">SECUNDUM</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Quelle des Taxonyms</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">NATIVENAME</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">56-stelliger deutscher Sippenname</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">AUTHOR</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Autorzitat </FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">SYNONYM</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Synonymiestatus (WAHR = ist ein Synonym)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">VALID_NR</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">5-stellige Taxonym-Nummer der akzeptierten Sippe (d.&nbsp;h. bei angenommenen Namen identisch mit SPECIES_NR; bei Synonymen auf SPECIES_NR des gültigen Namens verweisend)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">VALID_NAME</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Name der validen Sippe</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">GROUP</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Botanische Großgruppe (A = „Alge“, F = „Flechte“, M = „Moos“, G = „Gefäßpflanze“)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">RANG</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Taxonomische Rangstufe: ZUS=Segregat (zusätzliche Untergliederung zur Abbildung gegenüber der Standardsicht neuer Taxa; VA=Varietät; SSP=Subspecies;SPE=Art; SER=Serie; SSE=Subsection; AGG=Aggregat (zwischen Art und Gattung); SEC=Section; AG3=Aggregat zwischen Section und Gattung;SGE=Subgenus; GAT=Gattung;FAM=Familie;ORD=Ordnung;UKL=Unterklasse;KLA=Klasse;UAB=Unterabteilung;ABT=Abteilung;AG2=Aggregat höherer Taxa;ROOT=künstliches oberstes Taxon</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">AGG</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Aggregierung (d. h. SPECIES_NR des nächsthöheren, gültigen Taxonyms)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">AGG_NAME</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Name des nächsthöheren, gültigen Taxonyms</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">NACHWEIS</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Quelle für den Nachweis in Deutschland</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">HYBRID</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Hybridstatus (WAHR = ist ein Hybrid)</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">BEGRUENDUNG</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Verbale Begründung für Korrektur oder Ergänzung</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">IN_QUELLE</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Wurde der Name in der Quelle als gültig oder als Synonym geführt?</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">ELTER_1</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Stammsippe 1</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">ELTER_2</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Stammsippe 2</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">ELTER_3</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Stammsippe 3</FONT></TD>
	</TR>
	<TR>
		<TD HEIGHT="16" ALIGN="LEFT"><FONT FACE="Times New Roman">EDITSTATUS</FONT></TD>
		<TD ALIGN="LEFT"><FONT FACE="Times New Roman">Aus welcher Datei stammt der Eintrag (BfN, Korrekturliste, Ergänzungsliste)?</FONT></TD>
	</TR>
</TABLE>

